/*
	Stempora Web Framework
	Copyright (c) 2002-2018 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com				
*/

var STBPluginLightGallery = Object.create(STBModule.prototype);

STBPluginLightGallery.name = "PluginLightGallery";
STBPluginLightGallery.videoCounter = 1;

STBPluginLightGallery.stopVideoPlayers = function(event, prevIndex , index) {
	//stop anyother players
	var prev		= jQuery('.lg-outer .lg-item').eq(prevIndex);

	if (prev.length) {
		var players = plyr.get();
		
		if (players.length)	{
			for (i in players) {
				players[i].stop();
			}
		}
	}
}

STBPluginLightGallery.generateHiddenVideos = function() {
	jQuery("[data-video-type]:not(.__done_gallery_video)").each(function() {
		var el = jQuery(this);
			id = el.attr("data-html") ? STBUtils.str_replace("#" , "" , el.attr("data-html")) : "",
			src = jQuery(this).attr("data-custom-src"),			

			html = jQuery("<div />"),
			video = jQuery("<div />");

			html.css({
				display:	"none"
			});
			html.attr("id" , id);
			
			video.attr({
				"data-video-src"	: src,
				"data-video-poster"	: el.attr('data-video-poster'),
				"data-video-type"	: el.attr('data-video-type'),
				"id"				: id + "_inner"
			});
			
			html.append(video);

		jQuery("body").append(jQuery(html));
		jQuery(this).addClass("__done_gallery_video");
	});
}

STBPluginLightGallery.processContent = function() {
	var items = jQuery("[data-gal=true]");

	if (items.length) {
		items.each(function() {

			var item	= jQuery(this),
				source	= item.attr("data-gal-src"),
				tn		= item.attr("data-gal-tn"),
				title	= item.attr("data-gal-title");

			//data-sub-html="{TITLE}" data-html="#video{ID}" data-custom-src="{SOURCE}" data-video-type="local" data-video-poster="{TN}"


			//detect youtubr
			if (source.indexOf("www.youtube.com") != -1) {

				item.attr({
					"data-gal"			: "false",
					"data-sub-html"		: title,
					"data-html"			: "#video" + ++STBPluginLightGallery.videoCounter,
					"data-custom-src"	: source,
					"data-video-poster"	: tn,
					"data-video-type"	: "youtube",
					"data-tn"			: tn
				});

			} else {
				//detect vimeo
				if (source.indexOf("www.vimeo.com") != -1) {

				item.attr({
					"data-gal"			: "false",
					"data-sub-html"		: title,
					"data-html"			: "#video" + ++STBPluginLightGallery.videoCounter,
					"data-custom-src"	: source,
					"data-video-poster"	: tn,
					"data-video-type"	: "vimeo",
					"data-tn"			: tn
				});

				} else {
					//detect local video
					if (source.indexOf(".mp4") != -1) {
						item.attr({
							"data-gal"			: "false",
							"data-sub-html"		: title,
							"data-html"			: "#video" + ++STBPluginLightGallery.videoCounter,
							"data-custom-src"	: source,
							"data-video-poster"	: tn,
							"data-video-type"	: "local",
							"data-tn"			: tn
						});

					} else {
						//detect audio
						if (source.indexOf(".mp3") != -1) {
							item.attr({
								"data-gal"			: "false",
								"data-sub-html"		: title,
								"data-html"			: "#video" + ++STBPluginLightGallery.videoCounter,
								"data-custom-src"	: source,
								"data-video-poster"	: tn,
								"data-video-type"	: "audio",
								"data-tn"			: tn
							});

						} else {
							//lets assume this is an image
							item.attr({
								"data-gal"			: "false",
								"data-sub-html"		: title,
								"data-src"			: source,
								"data-tn"			: tn
							});

						}
					}
				}

			}

		});
	}

	STBPluginLightGallery.generateHiddenVideos();
}

STBPluginLightGallery.initVideoPlayer = function(event, prevIndex , index) {
	var el		= jQuery('.lg-outer .lg-item').eq(index),
		video	= el.find("[data-video-type]"),
		html	= "";

	if (video.length) {

		if (video.hasClass("__done")) {
			//start player
/*
			var players = plyr.get("#" + video.attr("id"));

			
			if (players.length)	{
				for (i in players) {
					players[i].play();
				}
			}

*/

		} else {

			try  {
				switch (video.attr("data-video-type")) {
					case "local":							
						html = 
							'<video controls preload="none" ' + (video.attr("data-video-poster") ? 'poster="' + video.attr("data-video-poster") + '"' : "") +'>' +
								'<source src="' + video.attr('data-video-src') + '" type="video/mp4">' +									 
							'</video>';
					break;													

					case 'youtube':
						html = '<div data-type="youtube" data-video-id="' + video.attr('data-video-src') + '"></div>';
					break;

					case 'vimeo':
						html = '<div data-type="vimeo" data-video-id="' + video.attr('data-video-src') + '"></div>';
					break;

					case 'audio':
						html = 
							'<div class="lg-audio-holder">' +
								'<audio class="" controls preload="none">' +
									'<source src="' + video.attr('data-video-src') + '" type="audio/mp4">' +									 
								'</audio>'
							'</div>';

					break;
				}

				if (html !== "") {
					video.html(html);
					plyr.setup(
						"#" + video.attr("id"),
						{
							autoplay	: false
						}
					);						
				}
				video.addClass("__done");
				
			} catch (e)	{
				getStack(0, e);
			}
		}

	}
}

STBPluginLightGallery.initGallery = function() {
	var options = {
		selector				: ".full-gallery-item",
		download				: false,
		fullScreen				: false,
		hash					: false,
		autoplay				: false,
		autoplayFirstVideo		: false,
		autoplayControls		: false,
		currentPagerPosition	: "middle",					
		exThumbImage			: 'data-tn',
		loadVimeoThumbnail		: false,
		loadYoutubeThumbnail	: false,
		getCaptionFromTitleOrAlt	: false,
	};

	jQuery(".full-gallery:not(.__done_gallery)").each(function() {		
		jQuery(this).lightGallery(options).on(
			"onAfterSlide.lg" , 
			STBPluginLightGallery.initVideoPlayer
		).on(
			"onBeforeSlide.lg" , 
			STBPluginLightGallery.stopVideoPlayers
		);

		jQuery(this).addClass("__done_gallery");
	});

	jQuery(".full-gallery-single:not(.__done_gallery)").each(function() {

		options.selector = 'this';

		jQuery(this).lightGallery(options).on(
			"onAfterSlide.lg" , 
			STBPluginLightGallery.initVideoPlayer
		).on(
			"onBeforeSlide.lg" , 
			STBPluginLightGallery.stopVideoPlayers
		);

		jQuery(this).addClass("__done_gallery");
	});


	
}

STBPluginLightGallery.runOnReady = function() {
	STBPluginLightGallery.processContent();
	STBPluginLightGallery.initGallery();
}

STBPluginLightGallery.runOnContentUpdate = function() {
	STBPluginLightGallery.processContent();
	STBPluginLightGallery.initGallery();
}

site.registerModule(STBPluginLightGallery);
